﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
//#include "gameFunctions/getPathValue.as"
//#include "gameProgram/parseVariablePaths.as"
#include "gameFunctions/nestedEval.as"
	// evalPath
	// resolveContainer
	// getImpliedValue

// run()
define_while = function( thisCommand_obj ){
	
	function once( func ){
		var done = false;
		return function () {
			trace("run once()");
			return done ? void 0 : ((done = true), func.apply(this, arguments));
		}
	}// once()
	
	
	
	var prom = VOW.make();
	function done( success ){
		if( success === undefined )		success = true;
		react_to_teleport.disable();
		react_to_newMap.disable();
		if( success ){
			prom.keep();
		}else{
			prom.doBreak();
		}
		return prom;
	}// done()
	// done = once( done );
	
	
	
	var index = 0;
	if( hasScript() )
		return runScript();
	else
		return done( true );
	
	
	
	
	function hasScript(){
		var hasCommands = (thisCommand_obj.script.length>0);
		var hasNonComments = false;
		for( var c=0; c<thisCommand_obj.script.length; c++){
			var innerType = thisCommand_obj.script[c].command_obj.data.type;
			if( innerType !== "comment"  &&  innerType !== undefined )
			{// if:  this command is valid, and not a comment  ( AKA: It actually does something )
				hasNonComments = true;
				break;		//  stop searching for valid non-comment commands
			}// if:  this command is valid, and not a comment  ( AKA: It actually does something )
		} // for:  each command within this loop
		return (hasCommands && hasNonComments);
	}// hasScript()
	
	
	
	function runScript(){
		var cmd_prom;
		var isSynchronous = true;
		
		if(  getConditionResult( thisCommand_obj )  ){
			// if( _this.scriptInterruptCheck() === false )
			// 	return done( false );
			// run entire inner script from the start.  cmd_prom represents the completion of that entire script
			cmd_prom = thisCommand_obj.script.runEvent( 0 );
			var promiseStatus = cmd_prom.getStatus();
			isSynchronous = (promiseStatus === "kept");
			if( promiseStatus === "broken" )
				return done( false );
			if( _this.scriptInterruptCheck() !== true )
				return done( false );
			if( !cmd_prom.is_promise )
				return done( false );
		}// while
		
		// loop finished
		else{
			return done();
		}
		
		
		// wait 1 frame between repeating synchronous loops containing no delays
		if( isSynchronous )
			setTimeout(function(){  runScript();  }, 33);
		// wait for inner-script's promise  (if it's async)
		else
			cmd_prom.then( runScript, done );
		
		return prom;
	}// runScript()
	
	
	
	function getConditionResult( thisCommand_obj ){
		var data = thisCommand_obj.data;
		
		// resolve target variable
		// parse any embedded variable paths
		var target_str = nestedEval( data.condition[0], "RAM", "_this" );
		var target = evalPath( target_str, "RAM", "_this" );
		//var target = getImpliedValue( target );		// convert string to appropriate datatype if neccessary
		
		// resolve value
		var thisValue = getImpliedValue(data.condition[2]);		// convert string to appropriate datatype if neccessary
		
		// parse any embedded variable paths
		thisValue = nestedEval( thisValue, "RAM", "_this" );
		var value = getImpliedValue( thisValue );
		
		
		// test the condition
		var conditionResult = false;
		switch(data.condition[1])
		{
			case "=":
				var conditionResult = (target == value);
			break;
			case "!=":
				var conditionResult = (target != value);
			break;
			case ">":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target > value);
			break;
			case ">=":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target >= value);
			break;
			case "<":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target < value);
			break;
			case "<=":
				if( isNaN(target)==false  &&  isNaN(value)==false )			// both target & value must be numbers
					var conditionResult = (target <= value);
			break;
		}// switch:  operator
		
	//	trace("\t condition:  "+data.condition[0]+" "+data.condition[1]+" "+data.condition[2]+"  ("+conditionResult+")");
		return conditionResult;
	}// getConditionResult()
	
	
}// define_while()